/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.command;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.util.Waitable;
import org.bukkit.event.server.TabCompleteEvent;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class ConsoleCommandCompleter
implements Completer {
    private final nz server;

    public ConsoleCommandCompleter(nz server) {
        this.server = server;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        final CraftServer server = this.server.server;
        final String buffer = line.line();
        Waitable<List<String>> waitable = new Waitable<List<String>>(){

            @Override
            protected List<String> evaluate() {
                List<String> offers1 = server.getCommandMap().tabComplete(server.getConsoleSender(), buffer);
                List<String> offers2 = server.getCraftCommandMap().tabComplete(server.getConsoleSender(), buffer);
                ArrayList<String> offers = new ArrayList<String>((Collection<String>)Sets.union((Set)(offers1 == null ? Collections.EMPTY_SET : Sets.newHashSet(offers1)), (Set)(offers2 == null ? Collections.EMPTY_SET : Sets.newHashSet(offers2))));
                TabCompleteEvent tabEvent = new TabCompleteEvent(server.getConsoleSender(), buffer, offers);
                server.getPluginManager().callEvent(tabEvent);
                return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
            }
        };
        server.getServer().processQueue.add(waitable);
        try {
            List offers = (List)waitable.get();
            if (offers == null) {
                return;
            }
            for (String completion : offers) {
                if (completion.isEmpty()) continue;
                candidates.add(new Candidate(completion));
            }
        }
        catch (ExecutionException e2) {
            server.getLogger().log(Level.WARNING, "Unhandled exception when tab completing", e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
        }
    }
}

